/*
 * Decompiled with CFR 0.152.
 */
package Cubos3d;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.Paint;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineBuilder;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class Cubos3D
extends Application {
    private final double sceneWidth = 1200.0;
    private final double sceneHeight = 600.0;
    private double mouseXold = 0.0;
    private double mouseYold = 0.0;
    private double mousePosX;
    private double mousePosY;
    private double mouseOldX;
    private double mouseOldY;
    private double mouseDeltaX;
    private double mouseDeltaY;
    final Cam camOffset = new Cam();
    final Cam cam = new Cam();
    private double nX = 2.0;
    private double nY = 2.0;
    private double nZ = 2.0;
    Color[] cores = new Color[]{Color.BLUE, Color.AQUAMARINE, Color.PALEGREEN, Color.YELLOWGREEN, Color.GREEN, Color.LIGHTYELLOW, Color.YELLOW, Color.ORANGE, Color.RED, Color.DARKRED, Color.SILVER};
    HashMap gridList = new HashMap();
    PhongMaterial[] materiais = new PhongMaterial[11];
    public int editElement = 1;
    public double valueEdit = 0.0;
    public int codigoMaterial = 5;
    public boolean editaPlanosFlag = false;
    public boolean editFunction = false;
    VBox varPrecisionMovements;
    VBox parametrosRede;
    VBox edicaoParcialRede;
    HBox symbolMenu;
    MenuBar teclasMenus = new MenuBar();
    TabPane controlPanel = new TabPane();
    BorderPane borderPane;
    HBox listOfGrids = new HBox();
    int editingGrid = 0;
    public String[] dialogs = new String[100];
    public static constantes listaConstantes = new constantes();

    public void start(Stage primaryStage) {
        this.loadDialogs();
        this.createMaterials();
        this.teclasMenus = this.defineMenu();
        this.createTabs();
        this.camOffset.getChildren().add((Object)this.cam);
        this.resetCam();
        SubScene scene = new SubScene((Parent)this.camOffset, 1200.0, 600.0, true, SceneAntialiasing.DISABLED);
        scene.setFill((Paint)Color.BLACK);
        scene.setCamera((Camera)new PerspectiveCamera());
        primaryStage.setTitle(this.dialogs[67]);
        double halfSceneWidth = scene.getWidth() / 2.0;
        double halfSceneHeight = scene.getHeight() / 2.0;
        this.cam.p.setX(halfSceneWidth);
        this.cam.ip.setX(-halfSceneWidth);
        this.cam.p.setY(halfSceneHeight);
        this.cam.ip.setY(-halfSceneHeight);
        this.frameCam(primaryStage, scene);
        this.definePalco(scene);
        this.borderPane = new BorderPane((Node)scene, (Node)this.teclasMenus, null, (Node)this.controlPanel, null);
        Scene scene2 = new Scene((Parent)this.borderPane);
        this.defineTeclasGlobais(primaryStage, scene2, scene);
        primaryStage.setScene(scene2);
        primaryStage.show();
    }

    private void createTabs() {
        this.varPrecisionMovements = this.definePrecisionMovement();
        this.varPrecisionMovements.setAlignment(Pos.CENTER);
        this.parametrosRede = this.createEntryFields();
        this.parametrosRede.setAlignment(Pos.CENTER);
        this.symbolMenu = this.createSymbolMenu();
        this.symbolMenu.setAlignment(Pos.CENTER);
        this.listOfGrids = this.createListGrids();
        Tab tabMovimentos = new Tab();
        tabMovimentos.setText(this.dialogs[49]);
        tabMovimentos.setContent((Node)this.varPrecisionMovements);
        this.controlPanel.getTabs().add((Object)tabMovimentos);
        Tab tabCriaRede = new Tab();
        tabCriaRede.setText(this.dialogs[50]);
        tabCriaRede.setContent((Node)this.parametrosRede);
        this.controlPanel.getTabs().add((Object)tabCriaRede);
        Tab tabSymbols = new Tab();
        tabSymbols.setText(this.dialogs[52]);
        tabSymbols.setContent((Node)this.symbolMenu);
        this.controlPanel.getTabs().add((Object)tabSymbols);
        Tab tabListOfGrids = new Tab();
        tabListOfGrids.setText(this.dialogs[53]);
        tabListOfGrids.setContent((Node)this.listOfGrids);
        this.controlPanel.getTabs().add((Object)tabListOfGrids);
    }

    private void createMaterials() {
        for (int i = 0; i < 10; ++i) {
            this.materiais[i] = new PhongMaterial();
            this.materiais[i].setDiffuseColor(this.cores[i]);
        }
    }

    private MenuBar defineMenu() {
        MenuBar menuBar = new MenuBar();
        Menu menuFile = new Menu(this.dialogs[3]);
        MenuItem readGrid = new MenuItem(this.dialogs[4]);
        readGrid.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                Cubos3D.this.selectGrid();
                Cubos3D.this.gridList.put(Cubos3D.this.editingGrid, Cubos3D.this.readGrid());
                Cubos3D.this.updateListOfGrids();
                Cubos3D.this.desenhaCubo();
                for (int j = 0; j < 10; ++j) {
                    ((TextField)((HBox)((ListView)Cubos3D.this.symbolMenu.getChildren().get(1)).getItems().get(j)).getChildren().get(1)).setText(String.format(Locale.ENGLISH, "%.9f", ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).escalasCores[Cubos3D.this.editElement - 1][j]));
                }
            }
        });
        MenuItem writeGrid = new MenuItem(this.dialogs[5]);
        writeGrid.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                Cubos3D.this.gravaGrelha((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid));
            }
        });
        MenuItem exitMenu = new MenuItem(this.dialogs[6]);
        exitMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                System.exit(0);
            }
        });
        menuFile.getItems().addAll((Object[])new MenuItem[]{readGrid, new SeparatorMenuItem(), writeGrid, new SeparatorMenuItem(), exitMenu});
        Menu menuModel = new Menu(this.dialogs[7]);
        MenuItem modelGrid = new MenuItem(this.dialogs[8]);
        modelGrid.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                Cubos3D.this.chooseGrid();
                Cubos3D.this.desenhaCubo();
            }
        });
        menuModel.getItems().addAll((Object[])new MenuItem[]{modelGrid, new SeparatorMenuItem()});
        menuBar.getMenus().addAll((Object[])new Menu[]{menuFile, menuModel});
        return menuBar;
    }

    private void defineTeclasGlobais(Stage primaryStage, Scene scene2, SubScene scene) {
        scene2.setOnKeyPressed(event -> {
            String keyPressed = event.getText();
            System.out.println(keyPressed);
            if (event.isControlDown() && event.isShiftDown()) {
                this.resetCam();
                this.frameCam(primaryStage, scene);
            }
            if (keyPressed.equals("+")) {
                this.cam.t.setX(this.cam.t.getX() + 1.0);
            }
            if (keyPressed.equals("/")) {
                VBox xx = (VBox)this.symbolMenu.getChildren().get(0);
                CheckBox checkBox = (CheckBox)xx.getChildren().get(0);
            }
            if (keyPressed.equals("-")) {
                System.out.println(((rede)this.gridList.get(this.editingGrid)).toString());
            }
            if (keyPressed.equals("*")) {
                for (int i = 0; i < ((rede)this.gridList.get(this.editingGrid)).lista.size(); ++i) {
                    celula cell = (celula)((rede)this.gridList.get(this.editingGrid)).devolveCelula(i);
                    System.out.println("i:" + i + "\n" + cell);
                }
            }
        });
    }

    private VBox defineParametrosRede() {
        Slider btReduce = this.createSliderPercentage(30.0);
        btReduce.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number old_val, Number new_val) {
                ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).reduce = (Double)new_val / 100.0;
                Cubos3D.this.desenhaCubo();
            }
        });
        VBox vbox3 = new VBox(10.0, new Node[]{btReduce, this.createFixedAxis()});
        vbox3.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        vbox3.setAlignment(Pos.CENTER);
        return vbox3;
    }

    private VBox definePrecisionMovement() {
        final Slider translactionXSlider = this.createSlider(0.0);
        Image imageTRight = new Image(((Object)((Object)this)).getClass().getResourceAsStream("tRight32.png"));
        Button buttonTRight = new Button();
        buttonTRight.setGraphic((Node)new ImageView(imageTRight));
        buttonTRight.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Cubos3D.this.cam.t.setX(Cubos3D.this.cam.t.getX() + translactionXSlider.valueProperty().getValue());
            }
        });
        final Slider translactionYSlider = this.createSlider(0.0);
        Image imageTLeft = new Image(((Object)((Object)this)).getClass().getResourceAsStream("tUp32.png"));
        Button buttonTLeft = new Button();
        buttonTLeft.setGraphic((Node)new ImageView(imageTLeft));
        buttonTLeft.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Cubos3D.this.cam.t.setY(Cubos3D.this.cam.t.getY() + translactionYSlider.valueProperty().getValue());
            }
        });
        final Slider translactionZSlider = this.createSlider(0.0);
        Image imageTDepth = new Image(((Object)((Object)this)).getClass().getResourceAsStream("tZ32.png"));
        Button buttonTDepth = new Button();
        buttonTDepth.setGraphic((Node)new ImageView(imageTDepth));
        buttonTDepth.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Cubos3D.this.cam.t.setZ(Cubos3D.this.cam.t.getZ() + translactionZSlider.valueProperty().getValue());
            }
        });
        HBox hboxTranslaction = new HBox(10.0, new Node[]{new Label(this.dialogs[55]), translactionXSlider, buttonTRight, new Label(this.dialogs[57]), translactionYSlider, buttonTLeft, new Label(this.dialogs[58]), translactionZSlider, buttonTDepth});
        hboxTranslaction.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        hboxTranslaction.setAlignment(Pos.CENTER);
        final Slider rotationXSlider = this.createSlider(0.0);
        Image imageRX = new Image(((Object)((Object)this)).getClass().getResourceAsStream("rX32.png"));
        Button buttonRX = new Button();
        buttonRX.setGraphic((Node)new ImageView(imageRX));
        buttonRX.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                double rxAngle = Cubos3D.this.cam.rx.getAngle();
                Cubos3D.this.cam.rx.setAngle(rxAngle + rotationXSlider.valueProperty().getValue());
            }
        });
        final Slider rotationYSlider = this.createSlider(0.0);
        Image imageRY = new Image(((Object)((Object)this)).getClass().getResourceAsStream("rY32.png"));
        Button buttonRY = new Button();
        buttonRY.setGraphic((Node)new ImageView(imageRY));
        buttonRY.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                double ryAngle = Cubos3D.this.cam.ry.getAngle();
                Cubos3D.this.cam.ry.setAngle(ryAngle + rotationYSlider.valueProperty().getValue());
            }
        });
        final Slider rotationZSlider = this.createSlider(0.0);
        Image imageRZ = new Image(((Object)((Object)this)).getClass().getResourceAsStream("rZ32.png"));
        Button buttonRZ = new Button();
        buttonRZ.setGraphic((Node)new ImageView(imageRZ));
        buttonRZ.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                double rzAngle = Cubos3D.this.cam.rz.getAngle();
                Cubos3D.this.cam.rz.setAngle(rzAngle + rotationZSlider.valueProperty().getValue());
            }
        });
        HBox hbox2 = new HBox(10.0, new Node[]{new Label(this.dialogs[56]), rotationXSlider, buttonRX, new Label(this.dialogs[57]), rotationYSlider, buttonRY, new Label(this.dialogs[58]), rotationZSlider, buttonRZ});
        hbox2.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        hbox2.setAlignment(Pos.CENTER);
        VBox vbox = new VBox(30.0, new Node[]{hboxTranslaction, hbox2});
        return vbox;
    }

    private void definePalco(SubScene scene) {
        scene.setOnMouseMoved(event -> {
            Node picked;
            if (event.isControlDown() && this.editFunction && null != (picked = event.getPickResult().getIntersectedNode()) && picked.getClass().getSimpleName().equals("Box")) {
                Box pickedMesh = (Box)picked;
                celula celulaEscolhida = (celula)pickedMesh.getUserData();
                pickedMesh.setMaterial((Material)this.materiais[this.codigoMaterial]);
                switch (this.editElement) {
                    case 1: {
                        celulaEscolhida.V1 = this.valueEdit;
                        break;
                    }
                    case 2: {
                        celulaEscolhida.V2 = this.valueEdit;
                        break;
                    }
                    case 3: {
                        celulaEscolhida.V3 = this.valueEdit;
                    }
                }
                pickedMesh.setUserData((Object)celulaEscolhida);
                ((rede)this.gridList.get(this.editingGrid)).addCelula(celulaEscolhida.indice, celulaEscolhida);
            }
        });
        scene.setOnScroll(event -> {
            double scale = this.cam.s.getX();
            double newScale = scale + event.getDeltaY() * 0.001;
            this.cam.s.setX(newScale);
            this.cam.s.setY(newScale);
            this.cam.s.setZ(newScale);
        });
        scene.setOnMouseDragged(event -> {
            this.mouseOldX = this.mousePosX;
            this.mouseOldY = this.mousePosY;
            this.mousePosX = event.getX();
            this.mousePosY = event.getY();
            this.mouseDeltaX = this.mousePosX - this.mouseOldX;
            this.mouseDeltaY = this.mousePosY - this.mouseOldY;
            if (event.isAltDown() && event.isShiftDown() && event.isPrimaryButtonDown()) {
                double rzAngle = this.cam.rz.getAngle();
                this.cam.rz.setAngle(rzAngle - this.mouseDeltaX);
            } else if (event.isAltDown() && event.isPrimaryButtonDown()) {
                double ryAngle = this.cam.ry.getAngle();
                this.cam.ry.setAngle(ryAngle - this.mouseDeltaX);
                double rxAngle = this.cam.rx.getAngle();
                this.cam.rx.setAngle(rxAngle + this.mouseDeltaY);
            } else if (event.isAltDown() && event.isMiddleButtonDown()) {
                double tx = this.cam.t.getX();
                double ty = this.cam.t.getY();
                this.cam.t.setX(tx + this.mouseDeltaX);
                this.cam.t.setY(ty + this.mouseDeltaY);
            }
        });
    }

    private Slider createSlider(double value) {
        Slider slider = new Slider(-30.0, 30.0, value);
        slider.setShowTickMarks(true);
        slider.setMajorTickUnit(10.0);
        slider.setMinorTickCount(10);
        slider.setBlockIncrement(10.0);
        slider.setShowTickLabels(true);
        return slider;
    }

    private VBox createFixedAxis() {
        final ToggleGroup groupAxis = new ToggleGroup();
        final VBox grupo = new VBox();
        final HBox valueSelected = new HBox();
        valueSelected.setPadding(new Insets(20.0, 0.0, 20.0, 0.0));
        grupo.setPadding(new Insets(20.0, 20.0, 10.0, 20.0));
        Button editaPlanos = new Button(this.dialogs[36]);
        editaPlanos.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                System.out.println("Porra");
                if (Cubos3D.this.editaPlanosFlag) {
                    Cubos3D.this.editaPlanosFlag = false;
                    ((Node)valueSelected.getChildren().get(0)).setVisible(false);
                    ((Node)valueSelected.getChildren().get(1)).setVisible(false);
                    ((Node)valueSelected.getChildren().get(2)).setVisible(false);
                    ((Node)grupo.getChildren().get(1)).setVisible(false);
                    ((Node)grupo.getChildren().get(2)).setVisible(false);
                    ((Node)grupo.getChildren().get(3)).setVisible(false);
                    for (int i = 0; i < ((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).lista.size(); ++i) {
                        celula cell = (celula)((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).devolveCelula(i);
                        cell.visivel = true;
                        ((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).addCelula(i, cell);
                    }
                    Cubos3D.this.desenhaCubo();
                } else {
                    Cubos3D.this.editaPlanosFlag = true;
                    ((Node)valueSelected.getChildren().get(0)).setVisible(true);
                    ((Node)valueSelected.getChildren().get(1)).setVisible(true);
                    ((Node)valueSelected.getChildren().get(2)).setVisible(true);
                    ((Node)grupo.getChildren().get(1)).setVisible(true);
                    ((Node)grupo.getChildren().get(2)).setVisible(true);
                    ((Node)grupo.getChildren().get(3)).setVisible(true);
                }
            }
        });
        RadioButton tb1 = new RadioButton(this.dialogs[37]);
        tb1.setToggleGroup(groupAxis);
        tb1.setSelected(true);
        tb1.setVisible(false);
        tb1.setUserData((Object)"X");
        RadioButton tb2 = new RadioButton(this.dialogs[38]);
        tb2.setToggleGroup(groupAxis);
        tb2.setVisible(false);
        tb2.setUserData((Object)"Y");
        RadioButton tb3 = new RadioButton(this.dialogs[39]);
        tb3.setToggleGroup(groupAxis);
        tb3.setVisible(false);
        tb3.setUserData((Object)"Z");
        groupAxis.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> ov, Toggle toggle, Toggle new_toggle) {
                int valor = 1;
                int valorRede = 0;
                switch ((String)groupAxis.getSelectedToggle().getUserData()) {
                    case "X": {
                        valor = ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).redeNX;
                        break;
                    }
                    case "Y": {
                        valor = ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).redeNY;
                        break;
                    }
                    case "Z": {
                        valor = ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).redeNZ;
                    }
                }
                Slider slider = (Slider)grupo.getChildren().get(2);
                slider.setMax((double)(valor - 1));
                slider.setMajorTickUnit(valor >= 4 ? (double)(valor / 4) : 1.0);
                slider.setSnapToTicks(true);
                slider.setBlockIncrement(1.0);
                slider.setMinorTickCount(1);
                slider.setShowTickMarks(true);
                slider.setShowTickLabels(true);
                slider.setValue((double)valorRede);
                slider.setVisible(true);
                slider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> ov, Number old_val, Number new_val) {
                        int valorRede = 0;
                        double init = System.currentTimeMillis();
                        for (int i = 0; i < ((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).lista.size(); ++i) {
                            celula cell = (celula)((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).devolveCelula(i);
                            switch ((String)groupAxis.getSelectedToggle().getUserData()) {
                                case "X": {
                                    valorRede = cell.x;
                                    break;
                                }
                                case "Y": {
                                    valorRede = cell.y;
                                    break;
                                }
                                case "Z": {
                                    valorRede = cell.z;
                                }
                            }
                            if (valorRede != new_val.intValue()) {
                                cell.visivel = false;
                                ((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).addCelula(i, cell);
                                continue;
                            }
                            cell.visivel = true;
                            ((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).addCelula(i, cell);
                        }
                        double end = System.currentTimeMillis();
                        System.out.println("Fim Desenho Plano:" + (end - init));
                        Cubos3D.this.desenhaCubo();
                    }
                });
                grupo.getChildren().remove(3);
                grupo.getChildren().remove(2);
                grupo.getChildren().add((Object)slider);
                Label etiqueta = new Label(String.format(" %2.0f", slider.getValue()));
                etiqueta.setVisible(true);
                grupo.getChildren().add((Object)etiqueta);
                Cubos3D.this.editaPlanosFlag = true;
                int x = 0;
                for (int i = 0; i < ((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).lista.size(); ++i) {
                    celula cell = (celula)((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).devolveCelula(i);
                    switch ((String)groupAxis.getSelectedToggle().getUserData()) {
                        case "X": {
                            valorRede = cell.x;
                            break;
                        }
                        case "Y": {
                            valorRede = cell.y;
                            break;
                        }
                        case "Z": {
                            valorRede = cell.z;
                        }
                    }
                    if (valorRede != x) {
                        cell.visivel = false;
                        ((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).addCelula(i, cell);
                        continue;
                    }
                    cell.visivel = true;
                    ((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).addCelula(i, cell);
                }
                Cubos3D.this.desenhaCubo();
            }
        });
        final Slider slider = new Slider(0.0, 1.0, 0.0);
        slider.setShowTickMarks(true);
        slider.setMajorTickUnit(1.0);
        slider.setMinorTickCount(1);
        slider.setBlockIncrement(1.0);
        slider.setSnapToTicks(true);
        slider.setShowTickLabels(true);
        slider.setVisible(false);
        slider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number old_val, Number new_val) {
                int valorRede = 0;
                for (int i = 0; i < ((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).lista.size(); ++i) {
                    celula cell = (celula)((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).devolveCelula(i);
                    switch ((String)groupAxis.getSelectedToggle().getUserData()) {
                        case "X": {
                            valorRede = cell.x;
                            break;
                        }
                        case "Y": {
                            valorRede = cell.y;
                            break;
                        }
                        case "Z": {
                            valorRede = cell.z;
                        }
                    }
                    if (valorRede != new_val.intValue()) {
                        cell.visivel = false;
                        ((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).addCelula(i, cell);
                        continue;
                    }
                    cell.visivel = true;
                    ((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).addCelula(i, cell);
                }
                grupo.getChildren().remove(3);
                Label etiqueta = new Label(String.format(" %2.0f", slider.getValue()));
                etiqueta.setVisible(true);
                grupo.getChildren().add((Object)etiqueta);
                Cubos3D.this.desenhaCubo();
            }
        });
        grupo.getChildren().add((Object)editaPlanos);
        valueSelected.getChildren().addAll((Object[])new Node[]{tb1, tb2, tb3});
        grupo.getChildren().add((Object)valueSelected);
        grupo.getChildren().add((Object)slider);
        grupo.setAlignment(Pos.CENTER);
        Label etiqueta = new Label(String.format(" %2.2f", slider.getValue()));
        etiqueta.setVisible(false);
        grupo.getChildren().add((Object)etiqueta);
        return grupo;
    }

    private Slider createSliderPercentage(double value) {
        Slider slider = new Slider(0.0, 100.0, value);
        slider.setShowTickMarks(true);
        slider.setMajorTickUnit(25.0);
        slider.setMinorTickCount(10);
        slider.setBlockIncrement(10.0);
        slider.setShowTickLabels(true);
        slider.setMaxWidth(200.0);
        return slider;
    }

    public void resetCam() {
        this.cam.t.setX(0.0);
        this.cam.t.setY(0.0);
        this.cam.t.setZ(0.0);
        this.cam.rx.setAngle(0.0);
        this.cam.ry.setAngle(0.0);
        this.cam.rz.setAngle(0.0);
        this.cam.s.setX(1.25);
        this.cam.s.setY(1.25);
        this.cam.s.setZ(1.25);
        this.cam.p.setX(0.0);
        this.cam.p.setY(0.0);
        this.cam.p.setZ(0.0);
        this.cam.ip.setX(0.0);
        this.cam.ip.setY(0.0);
        this.cam.ip.setZ(0.0);
        Bounds bounds = this.cam.getBoundsInLocal();
        double pivotX = bounds.getMinX() + bounds.getWidth() / 2.0;
        double pivotY = bounds.getMinY() + bounds.getHeight() / 2.0;
        double pivotZ = bounds.getMinZ() + bounds.getDepth() / 2.0;
        this.cam.p.setX(pivotX);
        this.cam.p.setY(pivotY);
        this.cam.p.setZ(pivotZ);
        this.cam.ip.setX(-pivotX);
        this.cam.ip.setY(-pivotY);
        this.cam.ip.setZ(-pivotZ);
    }

    public void frameCam(Stage stage, SubScene scene) {
        this.setCamOffset(this.camOffset, scene);
        this.setCamPivot(this.cam);
        this.setCamTranslate(this.cam);
        this.setCamScale(this.cam, scene);
    }

    private void setCamOffset(Cam camOffset, SubScene scene) {
        double width = scene.getWidth();
        double height = scene.getHeight();
        camOffset.t.setX(width / 2.0);
        camOffset.t.setY(height / 2.0);
    }

    private void setCamScale(Cam cam, SubScene scene) {
        Bounds bounds = cam.getBoundsInLocal();
        double pivotX = bounds.getMinX() + bounds.getWidth() / 2.0;
        double pivotY = bounds.getMinY() + bounds.getHeight() / 2.0;
        double pivotZ = bounds.getMinZ() + bounds.getDepth() / 2.0;
        double width = scene.getWidth();
        double height = scene.getHeight();
        double scaleFactorY = 1.0;
        double scaleFactorX = 1.0;
        if (bounds.getWidth() > 1.0E-4) {
            scaleFactorX = width / bounds.getWidth();
        }
        if (bounds.getHeight() > 1.0E-4) {
            scaleFactorY = height / bounds.getHeight();
        }
        double scaleFactor = scaleFactorX > scaleFactorY ? scaleFactorY : scaleFactorX;
        cam.s.setX(scaleFactor);
        cam.s.setY(scaleFactor);
        cam.s.setZ(scaleFactor);
    }

    private void setCamPivot(Cam cam) {
        Bounds bounds = cam.getBoundsInLocal();
        double pivotX = bounds.getMinX() + bounds.getWidth() / 2.0;
        double pivotY = bounds.getMinY() + bounds.getHeight() / 2.0;
        double pivotZ = bounds.getMinZ() + bounds.getDepth() / 2.0;
        cam.p.setX(pivotX);
        cam.p.setY(pivotY);
        cam.p.setZ(pivotZ);
        cam.ip.setX(-pivotX);
        cam.ip.setY(-pivotY);
        cam.ip.setZ(-pivotZ);
    }

    private void setCamTranslate(Cam cam) {
        Bounds bounds = cam.getBoundsInLocal();
        double pivotX = bounds.getMinX() + bounds.getWidth() / 2.0;
        double pivotY = bounds.getMinY() + bounds.getHeight() / 2.0;
        cam.t.setX(-pivotX);
        cam.t.setY(-pivotY);
    }

    private VBox createEntryFields() {
        int i;
        HBox panel1 = new HBox();
        HBox panel2 = new HBox();
        VBox panel = new VBox();
        panel2.setPadding(new Insets(20.0, 0.0, 20.0, 0.0));
        String[] labelStrings = new String[]{this.dialogs[18], this.dialogs[19], this.dialogs[20], this.dialogs[21], this.dialogs[22], this.dialogs[23], this.dialogs[24], this.dialogs[25], this.dialogs[26]};
        Label[] labels = new Label[labelStrings.length];
        final TextField[] fields = new TextField[labelStrings.length];
        int fieldNum = 0;
        TextField nPontosX = new TextField(this.dialogs[27]);
        nPontosX.setMaxWidth(40.0);
        fields[fieldNum++] = nPontosX;
        TextField nPontosY = new TextField(this.dialogs[28]);
        nPontosY.setMaxWidth(40.0);
        fields[fieldNum++] = nPontosY;
        TextField nPontosZ = new TextField(this.dialogs[29]);
        nPontosZ.setMaxWidth(40.0);
        fields[fieldNum++] = nPontosZ;
        TextField p1X = new TextField(this.dialogs[30]);
        p1X.setPrefWidth(90.0);
        fields[fieldNum++] = p1X;
        TextField p1Y = new TextField(this.dialogs[31]);
        p1Y.setMaxWidth(90.0);
        fields[fieldNum++] = p1Y;
        TextField p2X = new TextField(this.dialogs[32]);
        p2X.setMaxWidth(90.0);
        fields[fieldNum++] = p2X;
        TextField p2Y = new TextField(this.dialogs[33]);
        p2Y.setMaxWidth(90.0);
        fields[fieldNum++] = p2Y;
        TextField p1Z = new TextField(this.dialogs[34]);
        p1Z.setMaxWidth(90.0);
        fields[fieldNum++] = p1Z;
        TextField p2Z = new TextField(this.dialogs[35]);
        p2Z.setMaxWidth(90.0);
        fields[fieldNum++] = p2Z;
        for (i = 0; i < 3; ++i) {
            labels[i] = new Label(labelStrings[i]);
            labels[i].setLabelFor((Node)fields[i]);
            panel1.getChildren().add((Object)labels[i]);
            panel1.getChildren().add((Object)fields[i]);
        }
        for (i = 3; i < labelStrings.length; ++i) {
            labels[i] = new Label(labelStrings[i]);
            labels[i].setLabelFor((Node)fields[i]);
            panel2.getChildren().add((Object)labels[i]);
            panel2.getChildren().add((Object)fields[i]);
        }
        panel1.setAlignment(Pos.TOP_CENTER);
        panel2.setAlignment(Pos.TOP_CENTER);
        Button btNovaRede = new Button(this.dialogs[68]);
        btNovaRede.setStyle(this.dialogs[0]);
        btNovaRede.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                int nX = Integer.parseInt(fields[0].getText());
                int nY = Integer.parseInt(fields[1].getText());
                int nZ = Integer.parseInt(fields[2].getText());
                double p1X = Double.parseDouble(fields[3].getText());
                double p1Y = Double.parseDouble(fields[4].getText());
                double p2X = Double.parseDouble(fields[5].getText());
                double p2Y = Double.parseDouble(fields[6].getText());
                double p1Z = Double.parseDouble(fields[7].getText());
                double p2Z = Double.parseDouble(fields[8].getText());
                double V1 = 0.0;
                double V2 = 0.0;
                double V3 = 0.0;
                Cubos3D.this.selectGrid();
                Cubos3D.this.gridList.put(Cubos3D.this.editingGrid, Cubos3D.this.criaRede(nX, nY, nZ, p1X, p1Y, p2X, p2Y, p1Z, p2Z, 0.0, 0.0, 0.0));
                Cubos3D.this.updateListOfGrids();
                Cubos3D.this.desenhaCubo();
                Cubos3D.this.updateTextBoxSymbols();
            }
        });
        HBox botoesComando = new HBox();
        botoesComando.getChildren().add((Object)btNovaRede);
        botoesComando.setAlignment(Pos.TOP_CENTER);
        panel.getChildren().addAll((Object[])new Node[]{panel1, panel2, botoesComando});
        return panel;
    }

    private void updateTextBoxSymbols() {
        for (int j = 0; j < 10; ++j) {
            ((TextField)((HBox)((ListView)this.symbolMenu.getChildren().get(1)).getItems().get(j)).getChildren().get(1)).setText(String.format(Locale.ENGLISH, "%.9f", ((rede)this.gridList.get((Object)Integer.valueOf((int)this.editingGrid))).escalasCores[this.editElement - 1][j]));
        }
    }

    private void updateListOfGrids() {
        ObservableList obsList = ((ListView)this.listOfGrids.getChildren().get(0)).getItems();
        HBox hbGrid = (HBox)obsList.get(this.editingGrid);
        Label lbGrid = (Label)hbGrid.getChildren().get(1);
        CheckBox cbGrid = (CheckBox)hbGrid.getChildren().get(0);
        cbGrid.setSelected(true);
        lbGrid.setText(((rede)this.gridList.get((Object)Integer.valueOf((int)this.editingGrid))).name);
        hbGrid.getChildren().set(1, (Object)lbGrid);
        hbGrid.getChildren().set(0, (Object)cbGrid);
        obsList.set(this.editingGrid, (Object)hbGrid);
    }

    private HBox createEditValue() {
        HBox menuEdit = new HBox(10.0);
        menuEdit.setAlignment(Pos.CENTER);
        final CheckBox editCheckBox = new CheckBox(this.dialogs[69]);
        final TextField textEditValue = new TextField(this.dialogs[70]);
        textEditValue.setVisible(false);
        textEditValue.setMaxWidth(100.0);
        textEditValue.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Cubos3D.this.codigoMaterial = Cubos3D.this.returnColor(Double.parseDouble(textEditValue.getText()), Cubos3D.this.editingGrid);
                Cubos3D.this.valueEdit = Double.parseDouble(textEditValue.getText());
            }
        });
        editCheckBox.setSelected(false);
        editCheckBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                if (editCheckBox.isSelected()) {
                    textEditValue.setVisible(true);
                    Cubos3D.this.codigoMaterial = Cubos3D.this.returnColor(Double.parseDouble(textEditValue.getText()), Cubos3D.this.editingGrid);
                    Cubos3D.this.valueEdit = Double.parseDouble(textEditValue.getText());
                    Cubos3D.this.editFunction = true;
                } else {
                    textEditValue.setVisible(false);
                    Cubos3D.this.editFunction = false;
                }
            }
        });
        menuEdit.getChildren().addAll((Object[])new Node[]{editCheckBox, textEditValue});
        return menuEdit;
    }

    private HBox createEditElement() {
        HBox menuEdit = new HBox(20.0);
        menuEdit.setAlignment(Pos.CENTER);
        RadioButton cbV1 = new RadioButton(this.dialogs[14]);
        cbV1.setSelected(true);
        cbV1.setUserData((Object)1);
        RadioButton cbV2 = new RadioButton(this.dialogs[15]);
        cbV2.setSelected(false);
        cbV2.setUserData((Object)2);
        RadioButton cbV3 = new RadioButton(this.dialogs[16]);
        cbV3.setSelected(false);
        cbV3.setUserData((Object)3);
        final ToggleGroup tgValue = new ToggleGroup();
        cbV1.setToggleGroup(tgValue);
        cbV2.setToggleGroup(tgValue);
        cbV3.setToggleGroup(tgValue);
        tgValue.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> ov, Toggle old_toggle, Toggle new_toggle) {
                if (tgValue.getSelectedToggle() != null) {
                    Cubos3D.this.editElement = (Integer)tgValue.getSelectedToggle().getUserData();
                    for (int j = 0; j < 10; ++j) {
                        ((TextField)((HBox)((ListView)Cubos3D.this.symbolMenu.getChildren().get(1)).getItems().get(j)).getChildren().get(1)).setText(String.format(Locale.ENGLISH, "%.9f", ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).escalasCores[Cubos3D.this.editElement - 1][j]));
                    }
                    Cubos3D.this.desenhaCubo();
                }
            }
        });
        menuEdit.getChildren().addAll((Object[])new Node[]{cbV1, cbV2, cbV3});
        return menuEdit;
    }

    private HBox createSymbolMenu() {
        HBox caixaCores = new HBox();
        final CheckBox[] valores = new CheckBox[11];
        final TextField[] textoValorCores = new TextField[11];
        ListView listSymbols = new ListView();
        listSymbols.setMaxHeight(160.0);
        HBox[] codigo = new HBox[11];
        HBox editValue = new HBox();
        HBox editVariable = new HBox();
        editValue.setAlignment(Pos.TOP_CENTER);
        editVariable.setAlignment(Pos.CENTER);
        editValue = this.createEditValue();
        editVariable = this.createEditElement();
        VBox leftColumn = new VBox();
        leftColumn.getChildren().addAll((Object[])new Node[]{editValue, editVariable, this.defineParametrosRede()});
        leftColumn.setAlignment(Pos.CENTER);
        caixaCores.getChildren().add((Object)leftColumn);
        for (int i = 0; i < 11; ++i) {
            final int valor = i;
            codigo[i] = new HBox();
            valores[i] = new CheckBox(i < 10 ? "" + (i + 1) : this.dialogs[45]);
            String texto = String.format("#%02X%02X%02X", (int)(this.cores[i].getRed() * 255.0), (int)(this.cores[i].getGreen() * 255.0), (int)(this.cores[i].getBlue() * 255.0));
            valores[i].setStyle(this.dialogs[1] + texto + ";");
            valores[i].setPrefWidth(40.0);
            valores[i].setSelected(true);
            valores[i].setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    Cubos3D.this.codigoMaterial = valor;
                    double valorCelula = 0.0;
                    if (valores[valor].isSelected()) {
                        for (int j = 0; j < ((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).lista.size(); ++j) {
                            celula cell = (celula)((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).devolveCelula(j);
                            switch (Cubos3D.this.editElement) {
                                case 1: {
                                    valorCelula = cell.V1;
                                    break;
                                }
                                case 2: {
                                    valorCelula = cell.V2;
                                    break;
                                }
                                case 3: {
                                    valorCelula = cell.V3;
                                }
                            }
                            if (valor == Cubos3D.this.returnColor(valorCelula, Cubos3D.this.editingGrid) || Cubos3D.this.returnColor(valorCelula, Cubos3D.this.editingGrid) == 10 && valor == 10) {
                                cell.visivel = true;
                            }
                            ((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).addCelula(j, cell);
                        }
                    } else {
                        for (int j = 0; j < ((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).lista.size(); ++j) {
                            celula cell = (celula)((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).devolveCelula(j);
                            switch (Cubos3D.this.editElement) {
                                case 1: {
                                    valorCelula = cell.V1;
                                    break;
                                }
                                case 2: {
                                    valorCelula = cell.V2;
                                    break;
                                }
                                case 3: {
                                    valorCelula = cell.V3;
                                }
                            }
                            if (valor == Cubos3D.this.returnColor(valorCelula, Cubos3D.this.editingGrid) || Cubos3D.this.returnColor(valorCelula, Cubos3D.this.editingGrid) == 10 && valor == 10) {
                                cell.visivel = false;
                            }
                            ((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).addCelula(j, cell);
                        }
                    }
                    Cubos3D.this.desenhaCubo();
                }
            });
            textoValorCores[i] = new TextField(i < 10 ? "" + i : "-");
            textoValorCores[i].setStyle(this.dialogs[2]);
            textoValorCores[i].setPrefSize(160.0, valores[i].getHeight() - 5.0);
            textoValorCores[i].setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    int j;
                    double[] novaListaValores = new double[11];
                    for (j = 0; j < 10; ++j) {
                        novaListaValores[j] = Double.parseDouble(((TextField)((HBox)((ListView)Cubos3D.this.symbolMenu.getChildren().get(1)).getItems().get(j)).getChildren().get(1)).getText());
                    }
                    Arrays.sort(novaListaValores, 0, 10);
                    for (j = 0; j < 10; ++j) {
                        textoValorCores[j].setText(String.format(Locale.ENGLISH, "%.9f", novaListaValores[j]));
                    }
                    ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).valorCores = novaListaValores;
                    ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).escalasCores[Cubos3D.this.editElement - 1] = novaListaValores;
                    Cubos3D.this.desenhaCubo();
                }
            });
            textoValorCores[i].setEditable(true);
            codigo[i].getChildren().addAll((Object[])new Node[]{valores[i], textoValorCores[i]});
            listSymbols.getItems().add((Object)codigo[i]);
        }
        final String text = this.dialogs[0];
        final String text2 = this.dialogs[71];
        final Button btClassify = new Button(this.dialogs[72]);
        btClassify.setStyle(text);
        btClassify.onMouseEnteredProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                btClassify.setStyle(text + text2);
            }
        });
        btClassify.onMouseExitedProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                btClassify.setStyle(text);
            }
        });
        btClassify.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                int i;
                double[] listaValores = new double[10];
                ((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).recalculaLimites();
                switch (Cubos3D.this.editElement) {
                    case 1: {
                        for (i = 0; i < 10; ++i) {
                            listaValores[i] = ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).redeMinV1 + (double)i * (((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).redeMaxV1 - ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).redeMinV1) / 9.0;
                        }
                        ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).valorCores = listaValores;
                        ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).escalasCores[0] = ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).valorCores;
                        break;
                    }
                    case 2: {
                        for (i = 0; i < 10; ++i) {
                            listaValores[i] = ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).redeMinV2 + (double)i * (((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).redeMaxV2 - ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).redeMinV2) / 9.0;
                        }
                        ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).valorCores = listaValores;
                        ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).escalasCores[1] = ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).valorCores;
                        break;
                    }
                    case 3: {
                        for (i = 0; i < 10; ++i) {
                            listaValores[i] = ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).redeMinV3 + (double)i * (((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).redeMaxV3 - ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).redeMinV3) / 9.0;
                        }
                        ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).valorCores = listaValores;
                        ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).escalasCores[2] = ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).valorCores;
                    }
                }
                for (i = 0; i < 10; ++i) {
                    HBox hSymbol = (HBox)((ListView)Cubos3D.this.symbolMenu.getChildren().get(1)).getItems().get(i);
                    TextField t = (TextField)hSymbol.getChildren().get(1);
                    t.setText(String.format(Locale.ENGLISH, "%.9f", ((rede)Cubos3D.this.gridList.get((Object)Integer.valueOf((int)Cubos3D.this.editingGrid))).escalasCores[Cubos3D.this.editElement - 1][i]));
                    hSymbol.getChildren().set(1, (Object)t);
                    ((ListView)Cubos3D.this.symbolMenu.getChildren().get(1)).getItems().set(i, (Object)hSymbol);
                }
                Cubos3D.this.desenhaCubo();
            }
        });
        final Button btSaveScale = new Button(this.dialogs[47]);
        btSaveScale.setStyle(text);
        btSaveScale.onMouseEnteredProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                btSaveScale.setStyle(text + text2);
            }
        });
        btSaveScale.onMouseExitedProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                btSaveScale.setStyle(text);
            }
        });
        btSaveScale.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Cubos3D.this.saveScale();
            }
        });
        final Button btLoadScale = new Button(this.dialogs[48]);
        btLoadScale.setStyle(text);
        btLoadScale.onMouseEnteredProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                btLoadScale.setStyle(text + text2);
            }
        });
        btLoadScale.onMouseExitedProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                btLoadScale.setStyle(text);
            }
        });
        btLoadScale.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Cubos3D.this.loadScale();
            }
        });
        caixaCores.getChildren().add((Object)listSymbols);
        VBox vbButtonSymbol = new VBox();
        vbButtonSymbol.setAlignment(Pos.CENTER);
        vbButtonSymbol.getChildren().addAll((Object[])new Node[]{btClassify, btSaveScale, btLoadScale});
        caixaCores.getChildren().add((Object)vbButtonSymbol);
        return caixaCores;
    }

    private void desenhaEixos() {
        Line blackLineX = ((LineBuilder)((LineBuilder)((LineBuilder)((LineBuilder)LineBuilder.create().startX(-150.0).startY(0.0).endX(150.0).endY(0.0).fill((Paint)Color.BLUE)).stroke((Paint)Color.BLUE)).strokeWidth(2.0)).translateY(0.0)).build();
        this.cam.getChildren().add((Object)blackLineX);
        Text textX = new Text(0.0, 0.0, this.dialogs[59]);
        textX.setFill((Paint)Color.WHITE);
        textX.setTranslateX(150.0);
        this.cam.getChildren().add((Object)textX);
        Line blackLineY = ((LineBuilder)((LineBuilder)((LineBuilder)((LineBuilder)LineBuilder.create().startX(0.0).startY(-150.0).endX(0.0).endY(150.0).fill((Paint)Color.GREEN)).stroke((Paint)Color.GREEN)).strokeWidth(2.0)).translateY(0.0)).build();
        this.cam.getChildren().add((Object)blackLineY);
        Text textY = new Text(0.0, 0.0, this.dialogs[60]);
        textY.setFill((Paint)Color.WHITE);
        textY.setRotationAxis(Rotate.Z_AXIS);
        textY.setRotate(90.0);
        textY.setTranslateY(150.0);
        this.cam.getChildren().add((Object)textY);
        Line blackLineZ = ((LineBuilder)((LineBuilder)((LineBuilder)LineBuilder.create().startX(-150.0).startY(0.0).endX(150.0).endY(0.0).fill((Paint)Color.WHITE)).stroke((Paint)Color.WHITE)).strokeWidth(2.0)).build();
        blackLineZ.setRotationAxis(Rotate.Y_AXIS);
        blackLineZ.setRotate(90.0);
        this.cam.getChildren().add((Object)blackLineZ);
        Text textZ = new Text(0.0, 0.0, this.dialogs[61]);
        textZ.setFill((Paint)Color.WHITE);
        textZ.setTranslateZ(150.0);
        textZ.setRotationAxis(Rotate.Y_AXIS);
        textZ.setRotate(270.0);
        this.cam.getChildren().add((Object)textZ);
    }

    private void desenhaCubo() {
        double init = System.currentTimeMillis();
        this.cam.getChildren().removeAll((Collection)this.cam.getChildren().sorted());
        this.desenhaEixos();
        ObservableList obsList = ((ListView)this.listOfGrids.getChildren().get(0)).getItems();
        for (int j = 0; j < 5; ++j) {
            HBox hbGrid = (HBox)obsList.get(j);
            CheckBox cbGrid = (CheckBox)hbGrid.getChildren().get(0);
            if (!cbGrid.isSelected() || !this.gridList.containsKey(j)) continue;
            double[][] escalasCores = ((rede)this.gridList.get((Object)Integer.valueOf((int)j))).escalasCores;
            for (int i = 0; i < ((rede)this.gridList.get(j)).lista.size(); ++i) {
                celula cel = (celula)((rede)this.gridList.get(j)).devolveCelula(i);
                if (!cel.visivel) continue;
                Box cube = new Box(cel.lado.x * ((rede)this.gridList.get((Object)Integer.valueOf((int)j))).reduce, cel.lado.y * ((rede)this.gridList.get((Object)Integer.valueOf((int)j))).reduce, cel.lado.z * ((rede)this.gridList.get((Object)Integer.valueOf((int)j))).reduce);
                cube.setMaterial((Material)this.materiais[this.returnColor(this.editElement == 1 ? cel.V1 : (this.editElement == 2 ? cel.V2 : cel.V3), j)]);
                cube.setRotationAxis(Rotate.Y_AXIS);
                cube.setRotate(0.0);
                cube.setTranslateX(cel.p.x);
                cube.setTranslateY(cel.p.y);
                cube.setTranslateZ(cel.p.z);
                cube.setUserData((Object)cel);
                this.cam.getChildren().add((Object)cube);
            }
        }
        double fim = System.currentTimeMillis();
        System.out.println("Tempo:" + (fim - init));
    }

    private rede criaRede(int nx, int ny, int nz, double p1X, double p1Y, double p2X, double p2Y, double p1Z, double p2Z, double V1, double V2, double V3) {
        double dx = p2X - p1Y;
        double dy = p2Y - p1Y;
        double dz = p2Z - p1Z;
        double dcx = dx / (double)nx;
        double dcy = dy / (double)ny;
        double dcz = dz / (double)nz;
        double cx = dcx / 2.0;
        double cy = dcy / 2.0;
        double cz = dcz / 2.0;
        int contador = 0;
        rede redeNova = new rede(this.dialogs[54] + this.editingGrid);
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                int k = 0;
                while (k < nz) {
                    double a = p1X + cx + (double)i * dcx;
                    double b = p1Y + cy + (double)j * dcy;
                    double c = p1Z + cz + (double)k * dcz;
                    ponto pontoCentral = new ponto();
                    pontoCentral.x = a;
                    pontoCentral.y = b;
                    pontoCentral.z = c;
                    ponto arestas = new ponto();
                    celula cel = new celula();
                    cel.p = pontoCentral;
                    cel.V1 = V1;
                    cel.V2 = V2;
                    cel.V3 = V3;
                    cel.x = i;
                    cel.y = j;
                    cel.z = k++;
                    arestas.x = dcx;
                    arestas.y = dcy;
                    arestas.z = dcz;
                    cel.lado = arestas;
                    redeNova.addCelula(contador++, cel);
                }
            }
        }
        return redeNova;
    }

    private void saveScale() {
        Stage dialogo = new Stage();
        try {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle(this.dialogs[65]);
            String separador = ",";
            String nomeFicheiro = fileChooser.showSaveDialog((Window)dialogo).getAbsolutePath();
            FileWriter writer = new FileWriter(nomeFicheiro);
            for (int j = 0; j < 3; ++j) {
                String texto = "";
                for (int i = 0; i < 10; ++i) {
                    texto = texto + ((rede)this.gridList.get((Object)Integer.valueOf((int)this.editingGrid))).escalasCores[j][i] + separador;
                }
                writer.append(texto + "\n");
            }
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadScale() {
        Stage dialogo = new Stage();
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(this.dialogs[66]);
        String cvsSplitBy = ",";
        try {
            File file = fileChooser.showOpenDialog((Window)dialogo).getCanonicalFile();
            if (file.canRead()) {
                String line;
                String fileName = file.getCanonicalPath();
                int j = 0;
                BufferedReader br = new BufferedReader(new FileReader(fileName));
                while ((line = br.readLine()) != null) {
                    String[] values = line.split(cvsSplitBy);
                    for (int i = 0; i < 10; ++i) {
                        ((rede)this.gridList.get((Object)Integer.valueOf((int)this.editingGrid))).escalasCores[j][i] = Double.parseDouble(values[i]);
                    }
                    ++j;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadDialogs() {
        try {
            String line;
            String fileName = ".\\dialogs.csv";
            int i = 0;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            while ((line = br.readLine()) != null) {
                this.dialogs[i++] = line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void gravaGrelha(rede redeInterna) {
        Stage dialogo = new Stage();
        try {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setInitialFileName("*.csv");
            fileChooser.setTitle(this.dialogs[62]);
            String nomeFicheiro = fileChooser.showSaveDialog((Window)dialogo).getAbsolutePath();
            FileWriter writer = new FileWriter(nomeFicheiro);
            writer.append("Id, I(x), I(y), I(z), P(x), P(y), P(z), L(x), L(y), L(z), V1, V2, V3\n");
            for (int i = 0; i < redeInterna.lista.size(); ++i) {
                String texto = "";
                String separador = ",";
                celula cell = (celula)redeInterna.devolveCelula(i);
                texto = texto + cell.indice + separador;
                texto = texto + cell.x + separador + cell.y + separador + cell.z + separador;
                texto = texto + cell.p.x + separador + cell.p.y + separador + cell.p.z + separador;
                texto = texto + cell.lado.x + separador + cell.lado.y + separador + cell.lado.z + separador;
                texto = texto + cell.V1 + separador + cell.V2 + separador + cell.V3 + separador;
                writer.append(texto + "\n");
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private rede readGrid() {
        rede redeInterna = new rede(this.dialogs[63]);
        String cvsSplitBy = ",";
        Stage dialogo = new Stage();
        File file = new File("t");
        int i = 0;
        try {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle(this.dialogs[64]);
            file = fileChooser.showOpenDialog((Window)dialogo).getCanonicalFile();
            String fileName = file.getCanonicalPath();
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            if (!line.equals("Id, I(x), I(y), I(z), P(x), P(y), P(z), L(x), L(y), L(z), V1, V2, V3")) {
                System.exit(-1);
            }
            while ((line = br.readLine()) != null) {
                String[] linha = line.split(cvsSplitBy);
                celula cel = new celula();
                int id = Integer.parseInt(linha[0]);
                cel.x = Integer.parseInt(linha[1]);
                cel.y = Integer.parseInt(linha[2]);
                cel.z = Integer.parseInt(linha[3]);
                cel.p.x = Double.parseDouble(linha[4]);
                cel.p.y = Double.parseDouble(linha[5]);
                cel.p.z = Double.parseDouble(linha[6]);
                cel.lado.x = Double.parseDouble(linha[7]);
                cel.lado.y = Double.parseDouble(linha[8]);
                cel.lado.z = Double.parseDouble(linha[9]);
                cel.V1 = Double.parseDouble(linha[10]);
                cel.V2 = Double.parseDouble(linha[11]);
                cel.V3 = Double.parseDouble(linha[12]);
                redeInterna.addCelula(i, cel);
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        redeInterna.name = file.getName();
        return redeInterna;
    }

    private int returnColor(double value, int gridNumber) {
        int returnValue = 10;
        for (int i = 0; i < 9; ++i) {
            if (!(value >= ((rede)this.gridList.get((Object)Integer.valueOf((int)gridNumber))).escalasCores[this.editElement - 1][i]) || !(value <= ((rede)this.gridList.get((Object)Integer.valueOf((int)gridNumber))).escalasCores[this.editElement - 1][i + 1])) continue;
            returnValue = i;
        }
        return returnValue;
    }

    private double calculateVolume(ponto p1) {
        return p1.x * p1.y * p1.z;
    }

    private ponto calculateDistance(ponto p1, ponto p2) {
        double dx = Math.abs(p2.x - p1.x);
        double dy = Math.abs(p2.y - p1.y);
        double dz = Math.abs(p2.z - p1.z);
        ponto p = new ponto();
        p.x = dx;
        p.y = dy;
        p.z = dz;
        return p;
    }

    private HBox createListGrids() {
        final HBox listGridsBox = new HBox();
        final CheckBox[] bxGrid = new CheckBox[10];
        Label[] lbGrid = new Label[10];
        HBox[] hbGrid = new HBox[10];
        ObservableList data = FXCollections.observableArrayList();
        ListView listGrids = new ListView(data);
        listGrids.setMaxWidth(180.0);
        listGrids.setMaxHeight(120.0);
        listGrids.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Cubos3D.this.editingGrid = (Integer)newValue;
                if (Cubos3D.this.gridList.containsKey(Cubos3D.this.editingGrid)) {
                    ((TextArea)listGridsBox.getChildren().get(1)).setText(((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).toString());
                } else {
                    ((TextArea)listGridsBox.getChildren().get(1)).setText(Cubos3D.this.dialogs[41]);
                }
            }
        });
        for (int i = 0; i < 5; ++i) {
            final int valor = i;
            bxGrid[i] = new CheckBox();
            bxGrid[i].setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    if (bxGrid[valor].isSelected()) {
                        Cubos3D.this.editingGrid = valor;
                        ((ListView)Cubos3D.this.listOfGrids.getChildren().get(0)).getSelectionModel().select(valor);
                    }
                    if (Cubos3D.this.gridList.containsKey(Cubos3D.this.editingGrid)) {
                        ((TextArea)listGridsBox.getChildren().get(1)).setText(((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).toString());
                    } else {
                        ((TextArea)listGridsBox.getChildren().get(1)).setText(Cubos3D.this.dialogs[41]);
                    }
                    Cubos3D.this.desenhaCubo();
                }
            });
            lbGrid[i] = new Label(this.dialogs[40]);
            hbGrid[i] = new HBox();
            hbGrid[i].getChildren().addAll((Object[])new Node[]{bxGrid[i], lbGrid[i]});
            data.add((Object)hbGrid[i]);
        }
        Button btDeleteGrid = new Button(this.dialogs[42]);
        btDeleteGrid.setStyle(this.dialogs[0]);
        btDeleteGrid.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                if (Cubos3D.this.gridList.containsKey(Cubos3D.this.editingGrid)) {
                    // empty if block
                }
            }
        });
        listGridsBox.getChildren().addAll((Object[])new Node[]{listGrids, new TextArea(), btDeleteGrid});
        return listGridsBox;
    }

    private HBox createLineOfGrid(int value) {
        final int valor = value;
        final CheckBox bxGrid = new CheckBox();
        bxGrid.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                if (bxGrid.isSelected()) {
                    Cubos3D.this.editingGrid = valor;
                    ((ListView)Cubos3D.this.listOfGrids.getChildren().get(0)).getSelectionModel().select(valor);
                }
                ((TextArea)Cubos3D.this.listOfGrids.getChildren().get(1)).setText(((rede)Cubos3D.this.gridList.get(Cubos3D.this.editingGrid)).toString());
                Cubos3D.this.desenhaCubo();
            }
        });
        Label lbGrid = new Label(this.dialogs[40]);
        HBox hbGrid = new HBox();
        hbGrid.getChildren().addAll((Object[])new Node[]{bxGrid, lbGrid});
        return hbGrid;
    }

    public static void main(String[] args) {
        Cubos3D.launch((String[])args);
    }

    private void calculaAlfa(int[] gridNumber) {
        int i;
        double[][] alfaX = new double[((rede)this.gridList.get(gridNumber[1])).lista.size()][((rede)this.gridList.get(gridNumber[0])).lista.size()];
        double[][] alfaY = new double[((rede)this.gridList.get(gridNumber[1])).lista.size()][((rede)this.gridList.get(gridNumber[0])).lista.size()];
        double[][] alfaZ = new double[((rede)this.gridList.get(gridNumber[1])).lista.size()][((rede)this.gridList.get(gridNumber[0])).lista.size()];
        double[] dGX = new double[((rede)this.gridList.get(gridNumber[1])).lista.size()];
        double[] dGY = new double[((rede)this.gridList.get(gridNumber[1])).lista.size()];
        double[] dGZ = new double[((rede)this.gridList.get(gridNumber[1])).lista.size()];
        celula cel = (celula)((rede)this.gridList.get(gridNumber[0])).devolveCelula(0);
        double vol = this.calculateVolume(cel.lado);
        for (i = 0; i < ((rede)this.gridList.get(gridNumber[1])).lista.size(); ++i) {
            for (int j = 0; j < ((rede)this.gridList.get(gridNumber[0])).lista.size(); ++j) {
                celula cels = new celula();
                celula cels1 = (celula)((rede)this.gridList.get(gridNumber[0])).devolveCelula(j);
                celula cels2 = (celula)((rede)this.gridList.get(gridNumber[1])).devolveCelula(i);
                cels.p = this.calculateDistance(cels1.p, cels2.p);
                double dist = Math.pow(Math.sqrt(Math.pow(cels.p.x, 2.0) + Math.pow(cels.p.y, 2.0) + Math.pow(cels.p.z, 2.0)), 3.0);
                alfaX[i][j] = -Cubos3D.listaConstantes.g_universal * vol * cels.p.x / dist;
                alfaY[i][j] = -Cubos3D.listaConstantes.g_universal * vol * cels.p.y / dist;
                alfaZ[i][j] = -Cubos3D.listaConstantes.g_universal * vol * cels.p.z / dist;
            }
        }
        for (i = 0; i < ((rede)this.gridList.get(gridNumber[1])).lista.size(); ++i) {
            double somaX = 0.0;
            double somaY = 0.0;
            double somaZ = 0.0;
            for (int j = 0; j < ((rede)this.gridList.get(gridNumber[0])).lista.size(); ++j) {
                celula cels1 = (celula)((rede)this.gridList.get(gridNumber[0])).devolveCelula(j);
                somaX += cels1.V1 * alfaX[i][j];
                somaY += cels1.V1 * alfaY[i][j];
                somaZ += cels1.V1 * alfaZ[i][j];
            }
            dGX[i] = somaX;
            dGY[i] = somaY;
            dGZ[i] = somaZ;
            celula cell = new celula();
            cell = (celula)((rede)this.gridList.get(gridNumber[1])).devolveCelula(i);
            cell.V1 = -Cubos3D.listaConstantes.g_refz - dGZ[i];
            ((rede)this.gridList.get(gridNumber[1])).addCelula(i, cell);
        }
    }

    private void chooseGrid() {
        final Stage pStage = new Stage();
        final VBox vbList1 = new VBox();
        final VBox vbList2 = new VBox();
        HBox menu = new HBox();
        ComboBox listSource = new ComboBox();
        ComboBox listTarget = new ComboBox();
        int j = 0;
        for (int i = 0; i < 5; ++i) {
            String t = ((Label)((HBox)((ListView)this.listOfGrids.getChildren().get(0)).getItems().get(i)).getChildren().get(1)).getText();
            listSource.getItems().add(j, (Object)(t + ": " + i));
            listTarget.getItems().add(j, (Object)(t + ": " + i));
            ++j;
        }
        listSource.setPrefSize(200.0, 14.0);
        listTarget.setPrefSize(200.0, 14.0);
        listSource.getSelectionModel().selectFirst();
        listTarget.getSelectionModel().selectFirst();
        vbList1.getChildren().addAll((Object[])new Node[]{new Label(this.dialogs[11]), listSource});
        vbList2.getChildren().addAll((Object[])new Node[]{new Label(this.dialogs[12]), listTarget});
        menu.getChildren().addAll((Object[])new Node[]{vbList1, vbList2});
        Button btCalculate = new Button(this.dialogs[13]);
        btCalculate.setStyle(this.dialogs[0]);
        btCalculate.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                int[] returnValue = new int[]{((ComboBox)vbList1.getChildren().get(1)).getSelectionModel().getSelectedIndex(), ((ComboBox)vbList2.getChildren().get(1)).getSelectionModel().getSelectedIndex()};
                Cubos3D.this.calculaAlfa(returnValue);
                pStage.close();
            }
        });
        VBox sceneBox = new VBox();
        sceneBox.getChildren().addAll((Object[])new Node[]{menu, btCalculate});
        pStage.setScene(new Scene((Parent)sceneBox, 400.0, 250.0));
        pStage.show();
    }

    private void selectGrid() {
        final Stage pStage = new Stage();
        pStage.setTitle("Choose Grid");
        HBox menu = new HBox();
        final ListView listGrids = new ListView();
        int j = 0;
        for (int i = 0; i < 5; ++i) {
            String t = ((Label)((HBox)((ListView)this.listOfGrids.getChildren().get(0)).getItems().get(i)).getChildren().get(1)).getText();
            listGrids.getItems().add(j, (Object)("" + i + ": " + t));
            listGrids.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        Cubos3D.this.editingGrid = listGrids.getSelectionModel().getSelectedIndex();
                        pStage.close();
                    }
                }
            });
            ++j;
        }
        listGrids.getSelectionModel().select(this.editingGrid);
        menu.getChildren().addAll((Object[])new Node[]{listGrids});
        VBox sceneBox = new VBox();
        sceneBox.getChildren().addAll((Object[])new Node[]{menu});
        pStage.setScene(new Scene((Parent)sceneBox, 220.0, 120.0));
        pStage.showAndWait();
    }

    class rede {
        public int redeNX;
        public int redeNY;
        public int redeNZ;
        public double redeMinX;
        public double redeMinY;
        public double redeMinZ;
        public double redeMaxX;
        public double redeMaxY;
        public double redeMaxZ;
        public double redeMinV1;
        public double redeMinV2;
        public double redeMinV3;
        public double redeMaxV1;
        public double redeMaxV2;
        public double redeMaxV3;
        public String name;
        public double reduce = 0.3;
        public double[] valorCores = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        public double[][] escalasCores = new double[][]{this.valorCores, this.valorCores, this.valorCores};
        private HashMap lista = new HashMap();

        private rede(String nameGrid) {
            this.name = nameGrid;
        }

        public String toString() {
            String texto = "Name:" + this.name + "\nElements =" + this.lista.size() + "\nNx:" + this.redeNX + "\tNy:" + this.redeNY + "\tNz:" + this.redeNZ + "\nminV1:" + this.redeMinV1 + " \tminV2:" + this.redeMinV2 + " \tminV3:" + this.redeMinV3 + "\nmaxV1:" + this.redeMaxV1 + "\tmaxV2:" + this.redeMaxV2 + "\tmaxV3:" + this.redeMaxV3;
            return texto;
        }

        public void setName(String newName) {
            this.name = newName;
        }

        public void addCelula(int index, celula c) {
            this.verificaLimites(c);
            c.indice = index;
            this.lista.put(index, c);
        }

        public Object devolveCelula(int index) {
            return this.lista.get(index);
        }

        private void recalculaLimites() {
            for (int j = 0; j < this.lista.size(); ++j) {
                celula c = (celula)this.lista.get(j);
                if (j == 0) {
                    this.redeMinX = c.p.x;
                    this.redeMaxX = c.p.x;
                    this.redeMinY = c.p.y;
                    this.redeMaxY = c.p.y;
                    this.redeMinZ = c.p.z;
                    this.redeMaxZ = c.p.z;
                    this.redeMinV1 = c.V1;
                    this.redeMaxV1 = c.V1;
                    this.redeMinV2 = c.V2;
                    this.redeMaxV2 = c.V2;
                    this.redeMinV3 = c.V3;
                    this.redeMaxV3 = c.V3;
                    this.redeNX = c.x + 1;
                    this.redeNY = c.y + 1;
                    this.redeNZ = c.z + 1;
                    continue;
                }
                for (int i = 0; i < this.lista.size(); ++i) {
                    if (c.p.x < this.redeMinX) {
                        this.redeMinX = c.p.x;
                    }
                    if (c.p.x > this.redeMaxX) {
                        this.redeMaxX = c.p.x;
                    }
                    if (c.p.y < this.redeMinY) {
                        this.redeMinY = c.p.y;
                    }
                    if (c.p.y < this.redeMaxY) {
                        this.redeMaxY = c.p.y;
                    }
                    if (c.p.z < this.redeMinZ) {
                        this.redeMinZ = c.p.z;
                    }
                    if (c.p.z < this.redeMaxZ) {
                        this.redeMaxZ = c.p.z;
                    }
                    if (c.V1 < this.redeMinV1) {
                        this.redeMinV1 = c.V1;
                    }
                    if (c.V1 > this.redeMaxV1) {
                        this.redeMaxV1 = c.V1;
                    }
                    if (c.V2 < this.redeMinV2) {
                        this.redeMinV2 = c.V2;
                    }
                    if (c.V2 > this.redeMaxV2) {
                        this.redeMaxV2 = c.V2;
                    }
                    if (c.V3 < this.redeMinV3) {
                        this.redeMinV3 = c.V3;
                    }
                    if (c.V3 > this.redeMaxV3) {
                        this.redeMaxZ = c.V3;
                    }
                    if (this.redeNX < c.x + 1) {
                        this.redeNX = c.x + 1;
                    }
                    if (this.redeNY < c.y + 1) {
                        this.redeNY = c.y + 1;
                    }
                    if (this.redeNZ >= c.z + 1) continue;
                    this.redeNZ = c.z + 1;
                }
            }
        }

        private void verificaLimites(celula c) {
            if (this.lista.isEmpty()) {
                this.redeMinX = c.p.x;
                this.redeMaxX = c.p.x;
                this.redeMinY = c.p.y;
                this.redeMaxY = c.p.y;
                this.redeMinZ = c.p.z;
                this.redeMaxZ = c.p.z;
                this.redeMinV1 = c.V1;
                this.redeMaxV1 = c.V1;
                this.redeMinV2 = c.V2;
                this.redeMaxV2 = c.V2;
                this.redeMinV3 = c.V3;
                this.redeMaxV3 = c.V3;
                this.redeNX = c.x + 1;
                this.redeNY = c.y + 1;
                this.redeNZ = c.z + 1;
            } else {
                for (int i = 0; i < this.lista.size(); ++i) {
                    if (c.p.x < this.redeMinX) {
                        this.redeMinX = c.p.x;
                    }
                    if (c.p.x > this.redeMaxX) {
                        this.redeMaxX = c.p.x;
                    }
                    if (c.p.y < this.redeMinY) {
                        this.redeMinY = c.p.y;
                    }
                    if (c.p.y < this.redeMaxY) {
                        this.redeMaxY = c.p.y;
                    }
                    if (c.p.z < this.redeMinZ) {
                        this.redeMinZ = c.p.z;
                    }
                    if (c.p.z < this.redeMaxZ) {
                        this.redeMaxZ = c.p.z;
                    }
                    if (c.V1 < this.redeMinV1) {
                        this.redeMinV1 = c.V1;
                    }
                    if (c.V1 > this.redeMaxV1) {
                        this.redeMaxV1 = c.V1;
                    }
                    if (c.V2 < this.redeMinV2) {
                        this.redeMinV2 = c.V2;
                    }
                    if (c.V2 > this.redeMaxV2) {
                        this.redeMaxV2 = c.V2;
                    }
                    if (c.V3 < this.redeMinV3) {
                        this.redeMinV3 = c.V3;
                    }
                    if (c.V3 > this.redeMaxV3) {
                        this.redeMaxZ = c.V3;
                    }
                    if (this.redeNX < c.x + 1) {
                        this.redeNX = c.x + 1;
                    }
                    if (this.redeNY < c.y + 1) {
                        this.redeNY = c.y + 1;
                    }
                    if (this.redeNZ >= c.z + 1) continue;
                    this.redeNZ = c.z + 1;
                }
            }
        }
    }

    class celula {
        ponto p;
        double V1;
        double V2;
        double V3;
        int x;
        int y;
        int z;
        ponto lado;
        boolean visivel = true;
        int indice;

        public celula() {
            this.p = new ponto();
            this.lado = new ponto();
        }

        public String toString() {
            String texto = "celula {\nP(x)=" + this.p.x + " P(y)=" + this.p.y + " P(z)=" + this.p.z + "\nV1=" + this.V1 + " V2=" + this.V2 + " V3=" + this.V3 + "\nL(x)=" + this.lado.x + " L(y)=" + this.lado.y + " L(z)=" + this.lado.z + "\n x:" + this.x + " y:" + this.y + " z:" + this.z + "\nVisivel=" + this.visivel + "\n}";
            return texto;
        }
    }

    class ponto {
        double x;
        double y;
        double z;

        ponto() {
        }
    }

    class Cam
    extends Group {
        Translate t = new Translate();
        Translate p = new Translate();
        Translate ip = new Translate();
        Rotate rx = new Rotate();
        Rotate ry;
        Rotate rz;
        Scale s;

        public Cam() {
            this.rx.setAxis(Rotate.X_AXIS);
            this.ry = new Rotate();
            this.ry.setAxis(Rotate.Y_AXIS);
            this.rz = new Rotate();
            this.rz.setAxis(Rotate.Z_AXIS);
            this.s = new Scale();
            this.getTransforms().addAll((Object[])new Transform[]{this.t, this.p, this.rx, this.rz, this.ry, this.s, this.ip});
        }
    }

    public static class constantes {
        public final double g_universal = 6.674287 * Math.pow(10.0, -11.0);
        public final double g_refx = 0.0;
        public final double g_refy = 0.0;
        public final double g_refz = -9.8;
        public final double densidade_ref = 3200.0;
    }
}

