package OtimizacaoDeStocks;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.apache.commons.math3.distribution.NormalDistribution;
import java.util.LinkedList;
import java.util.Timer;

public class Calculos implements java.io.Serializable {

    public static int NUMERO_MAXIMO_DE_INTERACOES = 90;

    /* ********************************************************
     * VARIAVEIS DE INSTANCIA 
     */
    private double A;//custo de encomenda (euros)
    private double C1;//custo de compra (euros/ton)
    private double C2;//custo de pose (euros/ton)       
    private double C3; //custo de rotura (euros/ton)

    private double r;//procura média (ton/ano)       
    private double t;//tempo medio de reposição (dias)
    //private double sigma2;//variância da procura (ton/ano)       
    //private double sigmat; //desvio padrão do tempo de reposição (dias)
    private double sigmalinha;//variancia da procura durante o tempo de reposicao

    // calculadas para os parametros recebidos:
    private double A1;
    private double mulinha;
    
    private double alfa;
    private double M;
    private double etacalc;
    private double q;

    
    private String criterioParagem;

    // --
    private double limiar;
    private int numIteracao;

    private NormalDistribution normalDist;
    private LinkedList<Double> lista;
    private String optimizationDetails;


    /**
     * Construtor de um optimizador com os valores por omissao, para efeitos de
     * demonstracao.
     */
    public Calculos() {
        this.A = 80.0;
        this.C2 = 16.0;
        this.C3 = 150.0;
        this.r = 44.4;
        //this.sigma2 = 0.0;
        this.t = (60.0 / 365.0);
        //this.sigmat = (20.0 / 365.0);
        this.sigmalinha=Math.sqrt(5.9189);
        
        this.mulinha = t * r;
        this.A1 = Math.sqrt(2 * Math.PI);
        this.normalDist = new NormalDistribution(0, 1);
        this.limiar = 0.000001;
    }

    public Calculos(double A, double C2, double C3, double r, double t, double sigmalinha) {
         //colocar o t em dias (ou em anos)?
        //colocar o sigmat em dias (ou em anos)?
        this.A = A;
        this.C2 = C2;
        this.C3 = C3;
        this.r = r;
        //this.sigma2 = 0.0;
        this.t = (t / 365.0);
        //this.sigmat = (sigmat / 365.0);
        this.sigmalinha=Math.sqrt(sigmalinha);
        
        //cálculos auxiliares
        this.mulinha = this.t * r;
        this.A1 = Math.sqrt(2 * Math.PI);
        this.normalDist = new NormalDistribution(0, 1);
        this.limiar = 0.000001;

    }

    private double calculaQ(double eta) {
        System.out.println("O VALOR DE SIGMALINHA É" + sigmalinha);
        System.out.println("O VALOR DE Q É" + Math.sqrt(2 * r * ((A + C3 * eta) / C2)) );
        //auxEta=eta;
        return Math.sqrt(2 * r * ((A + C3 * eta) / C2));
        
    }

    private double calculaAlfa(double previousQ) {
        System.out.println("O VALOR DE ALFA É" + (C2 * previousQ) / C3 / r);
        return (C2 * previousQ) / C3 / r;
    }

    private double calculaEta(double previousQ) {
        double alfa1 = calculaAlfa(previousQ);
        System.out.println("O VALOR DE ALFA1 É" + alfa1);
        //auxAlfa=calculaAlfa(previousQ);
        double z1 = normalDist.inverseCumulativeProbability(1 - alfa1);
        System.out.println("O VALOR DE Z1 É" + z1);
        //double sigmalinha = Math.sqrt(sigmat * r * sigmat * r + sigmat * sigma2);
        
        double m1 = mulinha + sigmalinha * z1;
        System.out.println("O VALOR DE M1 É" + m1);
        
        double dzeta1 = Math.exp((-z1 * z1) / 2.0) / A1 - z1 * (1 - normalDist.cumulativeProbability(z1));
        double eta = dzeta1 * sigmalinha;
        System.out.println("O VALOR DE dzeta1 É" + dzeta1);
        System.out.println("O VALOR DE eta É" + eta);
        
        String debugStr= "Iteração " + numIteracao+"\n"
                +"Q "+previousQ+" ; alfa "+alfa1+" ; Z "+z1+" ; M "+m1+" ; dzeta "+dzeta1+" ; eta "+eta+"\n";
        
        // imprimir
        System.out.print(debugStr);
        // guardar essa string de debug, para mostrar mais depois
        optimizationDetails+= debugStr;
        alfa=alfa1;
        M=m1;
        return eta;
    }

    /**
     * Calcula o valor óptimo.
     *
     * @return
     */
    public double processa() {
        optimizationDetails = "";
        criterioParagem= "";
        numIteracao = 0;
        //cálculo do lote otimo (diferente para a 1ª iteração)
        double Q1 = calculaQ(0); // o mesmo que Math.sqrt((2 * A * r) / C2);
        lista = new LinkedList<Double>();
        lista.add(Q1);

        double Qnext = Q1;
        criterioParagem= "O programa parou porque atinjiu o número máximo de iterações!" + "\n"
                + "The program stoped because it reached the maximum number os iterations!";
        
        do {
            numIteracao++;
            // requisitos para a estimativa seguinte
            double eta = calculaEta(Q1);
            Qnext = calculaQ(eta);
            lista.add(Qnext);
            etacalc=eta;
            q=Qnext;
            //criterio de paragem.....................
            if (Math.min(Q1 / Qnext, Qnext / Q1) > 1 - limiar) {
                criterioParagem= " O Programa parou pois convergiu para a solução apresentada. " + "\n"
                        +" The program stopped because it converged to the presented solution. ";
                
                break;
            }
                Q1 = Qnext; // estimativa anterior passa a ser a atual  
        } while (numIteracao < NUMERO_MAXIMO_DE_INTERACOES);

        return Qnext;
    }

    public LinkedList<Double> getEstimatedValues() {
        return lista;
    }

    public String getOptimizationDetails() {
        return optimizationDetails;
    }
    
    public String getCriterioParagem() {
        return criterioParagem;
    }
    
    public double getAlfa(){
        BigDecimal bd = new BigDecimal(alfa);  
        bd = bd.setScale(3,BigDecimal.ROUND_HALF_UP);   
        alfa = bd.doubleValue();  
        return alfa;
    }
    
    public double getEta(){
        BigDecimal bd2 = new BigDecimal(etacalc);  
        bd2 = bd2.setScale(3,BigDecimal.ROUND_HALF_UP);   
        etacalc = bd2.doubleValue();  
        return etacalc;
    }
    
     public double getM(){
        BigDecimal bd3 = new BigDecimal(M);  
        bd3 = bd3.setScale(3,BigDecimal.ROUND_HALF_UP);   
        M = bd3.doubleValue();  
        return M;
    }
    
    public void imprimeLista() {
        for (double v : getEstimatedValues()) {
            System.out.println(v);
        }
    }
    
    public String getProcessResultadoArredondado() {
        double v= processa();
        DecimalFormat df = new DecimalFormat("#.###");      
        return df.format(v);
    }

    public double getPeriodoMedio() {
        double pmed;
        pmed = (q/r)*365.25;
        BigDecimal bd4 = new BigDecimal(pmed);  
        bd4 = bd4.setScale(3,BigDecimal.ROUND_HALF_UP);   
        pmed = bd4.doubleValue();  
        return pmed;
    }
    
      
    
    // TESTE:
    public static void main(String[] args) throws Exception {
        Calculos otim = new Calculos();
        double resultado = otim.processa();
        System.out.println("O valor de Q óptimo é: " + resultado);
        System.out.println("O número total de estimativas: " + otim.getEstimatedValues().size());
        otim.imprimeLista();
        System.out.println("O periodo médio entre encomendas é:" +otim.getPeriodoMedio() + " dias.");

    }

}
