package OtimizacaoDeStocks;

import java.io.Serializable;
import java.text.DecimalFormat;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;



@ManagedBean
@SessionScoped

public class DataBean implements Serializable {

    private double A;//custo de encomenda (euros)
    private double C2;//custo de pose (euros/ton)       
    private double C3; //custo de rotura (euros/ton)
    
    private double r;//procura média (ton/ano)       
    private double t;//tempo medio de reposição (anos)
    private double sigmalinha;//variancia da procura durante o tempo de reposicao
    //private double sigma2;//variância da procura (ton/ano)       
    //private double sigmat; //desvio padrão do tempo de reposição (anos)

    private double alfa;
    private double M;
    private double eta;
    private double pmed;
    
    private String optimizationDetails;
    private String criterioParagem;
     
    public DataBean() {
        optimizationDetails= "";
        criterioParagem= "";

    }
    
    
    // ================================
    /**
     * Exemplo para um parametro
     * @return 
     */
    public double getA() {
        return A;
    }
    
    public void setA(double A) {
        this.A = A;
    }
    
    public double getC2() {
        return C2;
    }
    
    public void setC2(double C2) {
        this.C2 = C2;
    }
    
    public double getC3() {
        return C3;
    }
    
    public void setC3(double C3) {
        this.C3 = C3;
    }
    
    public double getR() {
        return r;
    }
    
    public void setR(double r) {
        this.r = r;
    }
    
    public double getT() {
        return t;
    }
    
    public void setT(double t) {
        this.t = t;
    }
    
    public double getSigmalinha() {
        return sigmalinha;
    }
    
    public void setSigmalinha(double sigmalinha) {
        this.sigmalinha = sigmalinha;
    }
    
    /*
    public double getSigma2() {
        return sigma2;
    }
    
    public void setSigma2(double sigma2) {
       this.sigma2 = sigma2;
    }
            
    public double getSigmat() {
        return sigmat;
    }
    
    public void setSigmat(double sigmat) {
        this.sigmat = sigmat;
    }
    */

    /**
     * Aqui e' calculada a otimizacao...
     * 
     * @return 
     */    
    public double getProcessResultado() {
        try {
            // validacoes
            if (A==0 || C2==0 || C3==0 || t==0) {
                optimizationDetails= "Os valores devem ser superiores a zero!" + '\n' + "The values must be grather than zero!";
            }
            else { // OK:
                // criar novo objeto
                Calculos c1;
                c1= new Calculos(A, C2, C3, r, t, sigmalinha);
                double v= c1.processa();
                optimizationDetails= c1.getOptimizationDetails(); // invocar depois de processa()
                criterioParagem= c1.getCriterioParagem();
                alfa=c1.getAlfa();
                M=c1.getM();
                eta=c1.getEta();
                pmed=c1.getPeriodoMedio();
                return v;
            }
        }
        catch (Exception e) {
            System.err.println("\nPROBLEMA: " + e);
            e.printStackTrace();
            optimizationDetails= e.getMessage();
            criterioParagem= e.getMessage();
        }
        // em caso excecional:
        return 0; // caso exista algum problema na execucao
    }
    
    public String getOptimizationDetails() {
        return optimizationDetails;
    }
    
    public String getCriterioParagem() {
        return criterioParagem;
    }
     
   
    public double getProbabilidadeRotura() {
        return alfa;
    }

    public double getNivelEncomenda() {
        return M;
    }
    
    public double getNMedioUnidds() {
        return eta;
    }
    
     
    public double getPeriodoMedio() {
        return pmed;
    }
    
    public String getProcessResultadoArredondado() {
        double v= getProcessResultado();
        DecimalFormat df = new DecimalFormat("#.###");      
        return df.format(v);
    }
      
}
