/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package otimizacaodestocks;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class JanelaCliente
        implements ActionListener {

    String DEV_EMAIL = " brunojorgesilva84@gmail.com ";
    String APP_NAME = " Implementation Of An Iterative Process For Inventory Optimization ";

    protected static String ENVIAR = " ENVIAR ";
    protected static String SAIR = " SAIR ";

    private Calculos ultimoCalculo;

    private JTextArea qresult;
    private JTextField A_caixa, C2_caixa, C3_caixa, r_caixa, t_caixa, sigmalinha_caixa;

    private static final Font fontLabel = new Font("Arial", Font.PLAIN, 11);
    private JEditorPane outPane = null;

    private JFrame frame;
    ButtonGroup bgroup;

    int LARGURA = 665;
    int ALTURA = 600;

    private double A, C2, C3, r, t, sigmalinha;

    public JanelaCliente() {
        bgroup = new ButtonGroup();
    }

    public static void main(String[] args)
            throws Exception {
        JanelaCliente e = new JanelaCliente();

        e.initX();
    }

    public void initX() {
        frame = new JFrame(APP_NAME);
        frame.setSize(new Dimension(LARGURA, ALTURA));
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLocationRelativeTo(null);

        // campo para mostrar informacao, nao editavel
        qresult = new JTextArea(5, 70);
        qresult.setEditable(false);

        // parametros a preencher:
        A_caixa = new JTextField(8);
        t_caixa = new JTextField(8);
        C2_caixa = new JTextField(8);
        sigmalinha_caixa = new JTextField(8);
        r_caixa = new JTextField(8);
        C3_caixa = new JTextField(8);


        // mostrar
        updateFrame();
    }

    // actualizar o frame de acordo com o estado
    private void updateFrame() {

        try {
            if (outPane != null) {
                frame.setSize(new Dimension(LARGURA, ALTURA));
            }

            JPanel jp = new JPanel(new BorderLayout());

            Component centro = desenhaCentro();
            jp.add(centro, BorderLayout.CENTER);

            frame.setContentPane(jp);
        } catch (Exception e) {
            System.err.println("ERROR while uptading the frame: " + e);
            e.printStackTrace();
            System.exit(1);
        }
        // actualizar ==========
        if (outPane == null) {
            frame.pack();
        }
        frame.setVisible(true);
        // ---------------------
        //System.out.println("          == PAINEL ACTUALIZADO");
    }

    private Component desenhaCentro()
            throws Exception {
        if (outPane != null) {
            JScrollPane scrollPane = new JScrollPane(outPane);
            return scrollPane;
        } else {    //
            JPanel buttonP = new JPanel(new BorderLayout());
            JPanel p = new JPanel(new BorderLayout());
            //p.setBackground(Color.yellow);

            JPanel p1 = new JPanel(new BorderLayout());
            JPanel p12 = new JPanel(new BorderLayout());
            JPanel p3 = new JPanel(new BorderLayout());
            JPanel p4 = new JPanel(new BorderLayout());
            JPanel p2 = new JPanel(new GridLayout(1, 8));

            // *************************
            // campos das operacoes
            JPanel pbase = new JPanel(new GridLayout(4, 2));  // 4 linhas, 2 colunas
            // pbase.setBackground(Color.WHITE);
            pbase.setAlignmentX(Component.LEFT_ALIGNMENT);

            JPanel campos_1_1 = new JPanel(new FlowLayout(FlowLayout.RIGHT));
            campos_1_1.add(new JLabel("Order Costs [euros]"));
            campos_1_1.add(A_caixa);
            pbase.add(campos_1_1);

            JPanel campos_2_1 = new JPanel(new FlowLayout(FlowLayout.RIGHT));
            campos_2_1.add(new JLabel("<html> Holding Costs [euros.ton <sup> -1 </sup> ] </html>"));
            campos_2_1.add(C2_caixa);
            pbase.add(campos_2_1);

            JPanel campos_3_1 = new JPanel(new FlowLayout(FlowLayout.RIGHT));
            campos_3_1.add(new JLabel("<html> Shortage Costs [euros.ton <sup> -1 </sup> ] </html>"));
            campos_3_1.add(C3_caixa);
            pbase.add(campos_3_1);

            JPanel campos_4_1 = new JPanel(new FlowLayout(FlowLayout.RIGHT));
            campos_4_1.add(new JLabel("<html> Mean Demand [ton.year <sup> -1 </sup> ] </html>"));
            campos_4_1.add(r_caixa);
            pbase.add(campos_4_1);

            JPanel campos_1_2 = new JPanel(new FlowLayout(FlowLayout.RIGHT));
            campos_1_2.add(new JLabel("Mean Lead Time [days]"));
            campos_1_2.add(t_caixa);
            pbase.add(campos_1_2);
            
            JPanel campos_2_2 = new JPanel(new FlowLayout(FlowLayout.RIGHT));
            campos_2_2.add(new JLabel("<html> Lead Time Demand Variance [ton <sup> 2 </sup> ] </html>"));
            campos_2_2.add(sigmalinha_caixa);
            pbase.add(campos_2_2);

            
            /*
            JPanel campos_3_2 = new JPanel(new FlowLayout(FlowLayout.RIGHT));
            campos_3_2.add(new JLabel("Standard Deviation of Mean Replacement Time (days) "));
            campos_3_2.add(sigmat_caixa);
            pbase.add(campos_3_2);
            */
            p2.setAlignmentX(JPanel.CENTER_ALIGNMENT);
            // *************************

            p12.add(pbase, BorderLayout.WEST);
            p12.add(p1, BorderLayout.CENTER);

            // ****************
            JLabel lch = new JLabel(" RESULT ");
            lch.setFont(fontLabel);
            p2.add(qresult);
            p2.setAlignmentX(JPanel.CENTER_ALIGNMENT);

            p3.add(lch, BorderLayout.NORTH);
            p3.add(p2, BorderLayout.CENTER);

            JButton button2 = new JButton(" EXIT ");
            button2.addActionListener(this);
            button2.setActionCommand(SAIR);

            JButton button;
            if (ultimoCalculo != null) {
                button = new JButton(" SHOW ESTIMATES  ");
                button.addActionListener(this);
                button.setActionCommand("SHOW");
            } else {
                button = new JButton(" ESTIMATE  ");
                button.addActionListener(this);
                button.setActionCommand(ENVIAR);
            }

            //buttonP.add(button3, BorderLayout.CENTER);
            buttonP.add(button2, BorderLayout.WEST);
            buttonP.add(button, BorderLayout.EAST);

            p4.add(p3, BorderLayout.NORTH);
            p4.add(buttonP, BorderLayout.CENTER);
            // ****************

            p.add(new JLabel(" Optimal Amount Estimation "), BorderLayout.NORTH);
            p.add(p12, BorderLayout.WEST);
            p.add(p4, BorderLayout.SOUTH); // resultado e botao enviar
            return p;
        }
    }

    // EVENTO SOBRE O FRAME "ACTION"
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        //System.out.println("COMMAND: "+command);
        // ********************************************

        if (command.equals(SAIR)) {
            frame.dispose();
            System.exit(0);
        }

        if (command.equals(ENVIAR)) {

            String s = "";
            try {

                //custo de encomenda (euros)
                A = Double.parseDouble(A_caixa.getText());

                //custo de stocagem (euros/ton) 
                C2 = Double.parseDouble(C2_caixa.getText());

                //custo de roptura (euros/ton)
                C3 = Double.parseDouble(C3_caixa.getText());

                //CARACTERIZAÃ‡ÃƒO DA PROCURA
                //procura mÃ©dia (ton/ano)   
                r = Double.parseDouble(r_caixa.getText());

                //variãncia da procura (ton/ano)  
                sigmalinha = Double.parseDouble(sigmalinha_caixa.getText());

                //CARACTERIZAÃ‡ÃƒO DO TEMPO DE REPOSIÃ‡ÃƒO
                //tempo medio de reposiÃ§Ã£o (anos)
                t = Double.parseDouble(t_caixa.getText());

                //desvio padrÃ£o do tempo de reposiÃ§Ã£o (anos)
                //sigmat = Double.parseDouble(sigmat_caixa.getText());

                Calculos c = new Calculos(A, C2, C3, r, t, sigmalinha);
                double resultado = c.processa();
                String resultado2= c.getProcessResultadoArredondado();
                s += "The optimal amount is: " + resultado2;

                ultimoCalculo = c;

            } catch (Exception exc) { 
                s = "The fields should be filled with numeric values and grather than zero!";
            }

            System.err.println("DEBUG: " + s);
            if (s != null) {
                qresult.setText(s);
            }
        }

        if (command.equals("SHOW")) {
            if (ultimoCalculo != null) {
                String s = "";
//                for (int i = 0; i < ultimoCalculo.getEstimatedValues().size(); i++) {
//                    s += "Iteração " + (i + 1) + " " + ultimoCalculo.getEstimatedValues().get(i) + "\n";
//                }
                qresult.setText(ultimoCalculo.getOptimizationDetails());

            }

        }

        updateFrame();
    }

}
